package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;
import java.util.List;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@DiscriminatorValue("3")
public class GroupTask extends Task {

	public static final String REVIEW_TASK_STR = "Request ready for ";

	
	@ManyToOne
	@JoinColumn(name="groupownerid")
	Group groupOwner;
	
	GroupTask(){
		super();
	}
	
	public static List<GroupTask> listByOwner(final int ownerId) {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(ownerId);
	}
	
	public static List<GroupTask> listOpenByOwner(final int ownerId) {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByOwner(ownerId);
	}
	
	public static List<GroupTask> listOpenByOwnerAndRequestId(final int ownerId, final int requestId) {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByOwnerAndRequestId(ownerId, requestId);
	}	

	public static List<GroupTask> listOpenByWorkflowAndOwnerAndRequestId(final int workflowId, final int ownerId, final int requestId) {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByWorkflowAndOwnerAndRequestId(workflowId, ownerId, requestId);
	}	
	
	public static List<GroupTask> listByOwnerAndRequestId(final int ownerId, final int requestId) {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listByOwnerAndRequestId(ownerId, requestId);
	}	
	
	public static List<GroupTask> listAllGroupTasks() {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listAllGroupTasks();
	}
	
	public static List<GroupTask> listAllOpenGroupTasks() {
		return DartObjectFactory.getInstance().getGroupTaskDAO().listAllOpenGroupTasks();
	}
	
	
	public static GroupTask create(final RequestWorkflow workflow, final Request request, final Group owner, final String name, final String description, final String createdby) throws ValidationException {

		ValidationHelper.required("Created By", createdby);
		ValidationHelper.required("Owner", owner);
		ValidationHelper.required("Description", description);
		
		GroupTask result = new GroupTask();
		result.createdBy = createdby;
		result.createdOn = new Date();
		
		result.modify(workflow, request, name, createdby);
		result.groupOwner = owner;
		result.description = description;
		
		DartObjectFactory.getInstance().getGroupTaskDAO().save(result);
		
		return result;
	}

	public Group getGroupOwner() {
		return groupOwner;
	}
}
